//
//  WXKAddressCard.m
//  AnotherKyoponUtilities
//
//  Created by FUJIDANA on 08/03/11.
//  Copyright 2008 FUJIDANA. All rights reserved.
//

#import "WXKAddressCard.h"
#import <AddressBook/AddressBook.h>


@implementation WXKAddressCard

+ (NSDictionary *)dictionaryWithABPerson:(ABPerson *)person
{
	NSMutableDictionary *dictionary = [NSMutableDictionary dictionary];
	id value;
	
	// set name and phonetic name
	int showAsFlag = [[person valueForProperty:kABPersonFlags] intValue] & kABShowAsMask;
	if (showAsFlag == kABShowAsCompany)
	{
		value = [person valueForProperty:kABOrganizationProperty];
		if (value) [dictionary setObject:value forKey:@"name"];
	}
	else if (showAsFlag == kABShowAsPerson)
	{
		NSString *firstName = [person valueForProperty:kABFirstNameProperty];
//		NSString *middleName = [person valueForProperty:kABMiddleNameProperty];
		NSString *lastName = [person valueForProperty:kABLastNameProperty];
		NSString *phoneticFirstName = [person valueForProperty:kABFirstNamePhoneticProperty];
//		NSString *phoneticMiddleName = [person valueForProperty:kABMiddleNamePhoneticProperty];
		NSString *phoneticLastName = [person valueForProperty:kABLastNamePhoneticProperty];
		
		int nameOrderingFlag = [[person valueForProperty:kABPersonFlags] intValue] & kABNameOrderingMask;
		if (nameOrderingFlag == kABDefaultNameOrdering)
		{
			nameOrderingFlag = [[ABAddressBook sharedAddressBook] defaultNameOrdering];
		}
		NSMutableArray *nameArray = [NSMutableArray arrayWithCapacity:3];
		NSMutableArray *phoneticNameArray = [NSMutableArray arrayWithCapacity:3];
		
		if (nameOrderingFlag == kABFirstNameFirst)
		{
			if (firstName) [nameArray addObject:firstName];
//			if (middleName) [nameArray addObject:middleName];
			if (lastName) [nameArray addObject:lastName];
			if (phoneticFirstName) [phoneticNameArray addObject:phoneticFirstName];
//			if (phoneticMiddleName) [phoneticNameArray addObject:phoneticMiddleName];
			if (phoneticLastName) [phoneticNameArray addObject:phoneticLastName];
		}
		else
		{
			if (lastName) [nameArray addObject:lastName];
			if (firstName) [nameArray addObject:firstName];
//			if (middleName) [nameArray addObject:middleName];
			if (phoneticLastName) [phoneticNameArray addObject:phoneticLastName];
			if (phoneticFirstName) [phoneticNameArray addObject:phoneticFirstName];
//			if (phoneticMiddleName) [phoneticNameArray addObject:phoneticMiddleName];
		}
		
		NSString *fullName = [nameArray componentsJoinedByString:@" "];
		NSString *phoneticFullName = [phoneticNameArray componentsJoinedByString:@" "];
		
		[dictionary setObject:fullName forKey:@"name"];
		[dictionary setObject:phoneticFullName forKey:@"phoneticName"];
		
		value = [person valueForProperty:kABHomePageProperty];
		if (value) [dictionary setObject:value forKey:@"url"];
		
		value = [person valueForProperty:kABBirthdayProperty];
		if (value) [dictionary setObject:value forKey:@"birthday"];
		
		value = [person valueForProperty:kABNoteProperty];
		if (value) [dictionary setObject:value forKey:@"note"];
	}
	return dictionary;
}

//		// set phone numbers
//		ABMultiValue *abPhones = [abPerson valueForProperty:kABPhoneProperty];
//		if (abPhones) {
//			int primaryIndex = [abPhones indexForIdentifier:[abPhones primaryIdentifier]];
//			
//			int i = 0, num = [abPhones count];
//			for (i = 0; i < num; i++) {
//				NSString	*labelString	= [abPhones labelAtIndex:i];
//				NSString	*valueString	= [abPhones valueAtIndex:i];
//				int			label;
//				BOOL		preferable = (i == primaryIndex);
//				
//				if ([labelString isEqualToString:kABPhoneMobileLabel]) {
//					if ([[valueString substringToIndex:3] isEqualToString:@"070"]) {
//						label = AHKPHSPhoneType;
//					} else {
//						label = AHKCellularPhoneType;
//					}
//				} else if ([labelString isEqualToString:kABPhoneHomeLabel]) {
//					label = AHKHomePhoneType;
//				} else if ([labelString isEqualToString:kABPhoneWorkLabel]) {
//					label = AHKWorkPhoneType;
//				} else if ([labelString isEqualToString:kABPhoneHomeFAXLabel] || 
//						   [labelString isEqualToString:kABPhoneWorkFAXLabel]) {
//					label = AHKFaxPhoneType;
//				} else {
//					label = AHKOtherPhoneType;
//				}
//				[phones addValue:valueString withLabel:label preferred:preferable];
//			}
//		}
//		
//		// set email addresses
//		ABMultiValue *abEmails = [abPerson valueForProperty:kABEmailProperty];
//		if (abEmails) {
//			int primaryIndex = [abEmails indexForIdentifier:[abEmails primaryIdentifier]];
//			
//			int i = 0, num = [abEmails count];
//			for (i = 0; i < num; i++) {
//				NSString	*labelString	= [abEmails labelAtIndex:i];
//				NSString	*valueString	= [abEmails valueAtIndex:i];
//				int			label;
//				BOOL		preferable = (i == primaryIndex);
//				
//				if ([labelString isEqualToString:kABEmailWorkLabel]) {
//					if ([[valueString substringFromIndex:([valueString length] - 6)] isEqualToString:@".ac.jp"]) {
//						label = AHKSchoolEmailType;
//					} else {
//						label = AHKWorkEmailType;
//					}
//				} else if ([labelString isEqualToString:kABEmailHomeLabel]) {
//					label = AHKHomeEmailType;
//				} else {
//					label = AHKOtherEmailType;
//					
//					NSArray *domainComponents = [valueString componentsSeparatedByString:@"@"];
//					if ([domainComponents count] == 2) {
//						NSString *domainName = [domainComponents objectAtIndex:1];
//						domainComponents = [domainName componentsSeparatedByString:@"."];
//						if ([domainComponents count] >= 3) {
//							domainComponents = [domainComponents subarrayWithRange:NSMakeRange([domainComponents count] - 3, 3)];
//							domainName = [domainComponents componentsJoinedByString:@"."];
//							
//							if ([domainName isEqualToString:@"pdx.ne.jp"]) {
//								label = AHKPHSEmailType;
//								//preferable = YES;
//							} else if ([domainName isEqualToString:@"docomo.ne.jp"] ||
//									   [domainName isEqualToString:@"ezweb.ne.jp"] ||
//									   [domainName isEqualToString:@"vodafone.ne.jp"]) {
//								label = AHKCellularEmailType;
//								//preferable = YES;
//							}
//						}
//					}
//				}
//				[emails addValue:valueString withLabel:label preferred:preferable];
//			}
//		}
//		
//		// set address
//		ABMultiValue *addresses = [abPerson valueForProperty:kABAddressProperty];
//		if (addresses) {
//			int				primaryIndex		= [addresses indexForIdentifier:[addresses primaryIdentifier]];
//			NSString		*labelString		= [addresses labelAtIndex:primaryIndex];
//			NSDictionary	*addressDictionary	= [addresses valueAtIndex:primaryIndex];
//			NSString		*addressString;
//			int				label;
//			
//			if ([labelString isEqualToString:kABAddressWorkLabel]) {
//				label = AHKWorkAddressType;
//			} else if ([labelString isEqualToString:kABAddressHomeLabel]) {
//				label = AHKHomeAddressType;
//			} else {
//				label = AHKOtherAddressType;
//			}
//			[self setAddressLabel:label];
//			
//			//if ([[dictionary valueForKey:kABAddressCountryCodeKey] isEqualToString:@"ja"] == NO) {}
//			
//			NSString *addressZip	= [addressDictionary valueForKey:kABAddressZIPKey];
//			NSString *addressState	= [addressDictionary valueForKey:kABAddressStateKey];
//			NSString *addressCity	= [addressDictionary valueForKey:kABAddressCityKey];
//			NSString *addressStreet	= [addressDictionary valueForKey:kABAddressStreetKey];
//			
//			//if (addressZip == nil) addressZip = @"";
//			if (addressState == nil) addressState = @"";
//			if (addressCity == nil) addressCity = @"";
//			if (addressStreet == nil) addressStreet = @"";
//			if (addressZip) {
//				addressString = [NSString stringWithFormat:@"%@ %@ %@ %@", addressZip, addressState, addressCity, addressStreet];
//			} else {
//				addressString = [NSString stringWithFormat:@"%@ %@ %@", addressState, addressCity, addressStreet];
//			}
//			
//			if ([self validateAddressValue:&addressString error:nil]) {
//				[self setAddressValue:addressString];
//			}
//		}

- (void)awakeFromInsert
{
	[super awakeFromInsert];
}

 - (BOOL)setValuesWithVCardRepresentation:(NSData *)representation
{
	NSString *string = [[[NSString alloc] initWithData:representation encoding:NSShiftJISStringEncoding] autorelease];
	if (string == nil) return NO;
	
	return [self setValuesWithVCardRepresentationString:string];
}

- (BOOL)setValuesWithVCardRepresentationString:(NSString *)representationString
{
	// Combine lines separated by CRLF immediately followed by a single white space character 
	// (space, ASCII decimal 32, or horizontal tab, ASCII decimal 9). 
	// For details, see "5.8.1.  Line delimiting and folding" in RFC 2425, in which the format of vCard is described.
	NSArray *components;
	components = [representationString componentsSeparatedByString:@"\r\n "];
	if ([components count] > 1) representationString = [components componentsJoinedByString:@" "];
	components = [representationString componentsSeparatedByString:@"\r\n\t"];
	if ([components count] > 1) representationString = [components componentsJoinedByString:@" "];
	
	NSScanner *vCardScanner = [NSScanner scannerWithString:representationString];
	[vCardScanner setCharactersToBeSkipped:[NSCharacterSet whitespaceCharacterSet]];
	NSString *colonChar = @":";
	NSString *returnChar = @"\r\n";
	BOOL isVCard = NO;
	
	while ([vCardScanner isAtEnd] == NO)
	{
		NSString *type, *value;
		
		if ([vCardScanner scanUpToString:colonChar intoString:&type]
		 && [vCardScanner scanString:colonChar intoString:NULL]
		 && [vCardScanner scanUpToString:returnChar intoString:&value]
		 && [vCardScanner scanString:returnChar intoString:NULL])
		 {
			NSArray *typeArray = [type componentsSeparatedByString:@";"];
			NSString *typeName = [typeArray objectAtIndex:0];
			
			if (isVCard == NO)
			{
				if ([typeName caseInsensitiveCompare:@"BEGIN"] == NSOrderedSame &&
					[value caseInsensitiveCompare:@"VCARD"] == NSOrderedSame)
				{
					isVCard = YES;
					continue;
				}
			}
			else
			{
//				
//				NSError *outError;
//				
				if ([typeName caseInsensitiveCompare:@"END"] == NSOrderedSame &&
					[value caseInsensitiveCompare:@"VCARD"] == NSOrderedSame)
				{
					break;
				}
			}
		 }
	}
 	return NO;
}

//					} else if ([typeName caseInsensitiveCompare:@"FN"] == NSOrderedSame) {
//						if ([self validateName:&value error:&outError]) {
//							[self setName:value];
//						}
//					} else if ([typeName caseInsensitiveCompare:@"X-REDUCTION"] == NSOrderedSame) {
//						NSNumber *newNumber = [NSNumber numberWithInt:[value intValue]];
//						if ([self validateNumber:&newNumber error:&outError]) {
//							[self setNumber:[newNumber intValue]];
//						}
//					} else if ([typeName caseInsensitiveCompare:@"SORT-STRING"] == NSOrderedSame) {
//						if ([self validatePhoneticName:&value error:&outError]) {
//							[self setPhoneticName:value];
//						}
//					} else if ([typeName caseInsensitiveCompare:@"X-GNO"] == NSOrderedSame) {
//						NSNumber *newGroupNumber = [NSNumber numberWithInt:[value intValue]];
//						if ([self validateGroupNumber:&newGroupNumber error:&outError]) {
//							[self setGroupNumber:[newGroupNumber intValue]];
//						}
//					} else if ([typeName caseInsensitiveCompare:@"TEL"] == NSOrderedSame) {
//						BOOL preferred = NO;
//						NSString *labelString;
//						if ([AHKPerson scanTypeArray:typeArray
//									 intoLabelString:&labelString
//										   preferred:&preferred]) {
//							[phones addValue:value
//							 withLabelString:labelString
//								   preferred:preferred];
//						}
//					} else if ([typeName caseInsensitiveCompare:@"EMAIL"] == NSOrderedSame) {
//						BOOL preferred = NO;
//						NSString *labelString;
//						if ([AHKPerson scanTypeArray:typeArray
//									 intoLabelString:&labelString
//										   preferred:&preferred]) {
//							[emails addValue:value
//							 withLabelString:labelString
//								   preferred:preferred];
//						}
//					} else if ([typeName caseInsensitiveCompare:@"ADR"] == NSOrderedSame) {
//						NSString *labelString;
//						BOOL preferred;
//						if ([AHKPerson scanTypeArray:typeArray
//									 intoLabelString:&labelString
//										   preferred:&preferred]) {
//							if ([self validateAddressValue:&value error:&outError]) {
//								[self setAddressLabelString:labelString];
//								[self setAddressValue:value];
//							}
//						}
//					} else if ([typeName caseInsensitiveCompare:@"X-BLOODTYPE"] == NSOrderedSame) {
//						[self setBloodTypeString:value];
//					} else if ([typeName caseInsensitiveCompare:@"BDAY"] == NSOrderedSame) {
//						// if ([self validateBirthday:&label error:&outError]) {
//						//	[self setBirthday:valueString];
//						// }
//						if ([value length] == 8) {
//							NSRange	yearRange	= NSMakeRange(0, 4);
//							NSRange	monthRange	= NSMakeRange(4, 2);
//							NSRange	dayRange	= NSMakeRange(6, 2);
//							[self setBirthday:[NSCalendarDate dateWithYear:[[value substringWithRange:yearRange] intValue]
//																	 month:[[value substringWithRange:monthRange] intValue]
//																	   day:[[value substringWithRange:dayRange] intValue]
//																	  hour:0
//																	minute:0
//																	second:0
//																  timeZone:[NSTimeZone defaultTimeZone]]];
//						}
//					} else if ([typeName caseInsensitiveCompare:@"X-CONSTELLATION"] == NSOrderedSame) {
//						[self setZodiacString:value];
//					} else if ([typeName caseInsensitiveCompare:@"X-HOBBY"] == NSOrderedSame) {
//						if ([self validateHobby:&value error:&outError]) {
//							[self setHobby:value];
//						}
//					} else if ([typeName caseInsensitiveCompare:@"NOTE"] == NSOrderedSame) {
//						if ([self validateNote:&value error:&outError]) {
//							[self setNote:value];
//						}
//					} else if ([typeName caseInsensitiveCompare:@"URL"] == NSOrderedSame) {
//						if ([self validateUrl:&value error:&outError]) {
//							[self setUrl:value];
//						}
//					} else if ([typeName caseInsensitiveCompare:@"CLASS"] == NSOrderedSame) {
//						BOOL b = ([value caseInsensitiveCompare:@"PRIVATE"] == NSOrderedSame
//								  || [value isEqualToString:@"1"]);
//						[self setSecured:b];
//					}
//				}
//			} else {
//				[vCardScanner scanUpToString:returnChar intoString:NULL];
//				[vCardScanner scanString:returnChar intoString:NULL];
//			}
//		}
//		
//		if (isVCard == NO) {
//			[self release];
//			return nil;
//		}


- (NSData *)vCardRepresentation
{
	return [[self vCardRepresentationString] dataUsingEncoding:NSShiftJISStringEncoding];
}

- (NSString *)vCardRepresentationString
{
		NSMutableString *vCardString = [NSMutableString stringWithCapacity:512];
		id value;
		
		[vCardString appendString:@"BEGIN:VCARD\r\nVERSION:3.0\r\n"];
		
		value = [self valueForKey:@"name"];
		if (value) [vCardString appendFormat:@"FN:%@\r\n", value];
		
		value = [self valueForKey:@"index"];
		[vCardString appendFormat:@"X-REDUCTION:%i\r\n", [value longValue]];
		
		value = [self valueForKey:@"phoneticName"];
		if (value) [vCardString appendFormat:@"SORT-STRING:%@\r\n", value];
		
		value = [self valueForKeyPath:@"container.order"];
		[vCardString appendFormat:@"X-GNO:%i\r\n", [value longValue]];
		
//		NSString *valueString;
//		int i;
//		int preferredIndex;
//		
//		preferredIndex = [[self phones] indexForPreferredValue];
//		for (i = 0; i < 3; i++) {
//			if (valueString = [[self phones] valueAtIndex:i]) {
//				NSString *labelString = [[self phones] labelStringAtIndex:i];
//				if (i == preferredIndex) {
//					[vCardString appendFormat:@"TEL;TYPE=PREF,%@:%@\r\n", labelString, valueString];
//				} else {
//					[vCardString appendFormat:@"TEL;TYPE=%@:%@\r\n", labelString, valueString];
//				}
//			}
//		}
//		
//		preferredIndex = [[self emails] indexForPreferredValue];
//		for (i = 0; i < 3; i++) {
//			if (valueString = [[self emails] valueAtIndex:i]) {
//				NSString *labelString = [[self emails] labelStringAtIndex:i];
//				if (i == preferredIndex) {
//					[vCardString appendFormat:@"EMAIL;TYPE=PREF,%@:%@\r\n", labelString, valueString];
//				} else {
//					[vCardString appendFormat:@"EMAIL;TYPE=%@:%@\r\n", labelString, valueString];
//				}
//			}
//		}
//		
//		if (valueString = [self addressValue]) {
//			[vCardString appendFormat:@"ADR;TYPE=%@:%@\r\n", [self addressLabelString], valueString];
//		}
//		
//		if ([self bloodType] != AHKUnclassifiedBloodType) {
//			[vCardString appendFormat:@"X-BLOODTYPE:%@\r\n", [self bloodTypeString]];
//		}
//		

//	value = [self valueForKey:@"birthday"];
//	if (value)
//			int year = [[self birthday] yearOfCommonEra];
//			int month = [[self birthday] monthOfYear];
//			int day = [[self birthday] dayOfMonth];
//			
//			[vCardString appendFormat:@"BDAY:%04d%02d%02d\r\n", year, month, day];
//		}
//		
//		if ([self zodiac] != AHKUnclassifiedConstellation) {
//			[vCardString appendFormat:@"X-CONSTELLATION:%@\r\n", [self zodiacString]];
	
	value = [self valueForKey:@"hobby"];
	if (value) [vCardString appendFormat:@"X-HOBBY:%@\r\n", value];
	
	value = [self valueForKey:@"note"];
	if (value) [vCardString appendFormat:@"NOTE:%@\r\n", value];
	
	value = [self valueForKey:@"url"];
	if (value) [vCardString appendFormat:@"URL:%@\r\n", value];
	
	value = [self valueForKey:@"secured"];
	if ([value boolValue] != nil) [vCardString appendString:@"CLASS:PRIVATE\r\n"];
	else [vCardString appendString:@"CLASS:PUBLIC\r\n"];
	
	[vCardString appendString:@"END:VCARD\r\n"];
	
	return vCardString;	
}

@end

//#import "AHKNumbering.h"
//#import "AHKMultiValue.h"
//#import <AddressBook/AddressBook.h>
//#import "NSString_FJNFullwidthHalfwidth.h"
//
////@interface NSString (FJDNMimeEscape)
////- (NSString *)stringByAddingBackslashEscapesInRFC2445;
////- (NSString *)stringByReplacingBackslashEscapesInRFC2445;
////@end
//
//@interface AHKPerson (VCard_Private)
//
//+ (BOOL)guessEncoding:(NSStringEncoding *)encoding FromVCardRepresentation:(NSData *)data;
//+ (BOOL)scanTypeArray:(NSArray *)typeArray intoLabelString:(NSString **)labelString preferred:(BOOL *)isPreferred;
//- (NSString *)vCardRepresentationStringWithFormat:(AHKVCardFormat)format;
//
//@end
//
//@implementation AHKPerson (VCard)
//
//#pragma mark class methods
//
//+ (NSArray *)peopleWithVCardRepresentation:(NSData *)data
//{
//	NSStringEncoding encoding;
//	[AHKPerson guessEncoding:&encoding FromVCardRepresentation:data];
//	
//	NSString	*string		= [[NSString alloc] initWithData:data
//													encoding:encoding];
//	if (string == nil) return nil;
//	
//	NSScanner	*scanner	= [[NSScanner alloc] initWithString:string];
//	
//	NSString	*tempString1, *tempString2;
//	NSData		*separatedVCardData;
//	ABPerson	*abPerson;
//	AHKPerson	*ahkPerson;
//	
//	NSMutableArray	*array	= [NSMutableArray array];
//	 
//	while ([scanner isAtEnd] == NO) {
//		[scanner scanUpToString:@"END:VCARD\r\n" intoString:&tempString1];
//		[scanner scanString:@"END:VCARD\r\n" intoString:&tempString2];
//		
//		separatedVCardData = [[tempString1 stringByAppendingString:tempString2] dataUsingEncoding:NSUnicodeStringEncoding];
//		abPerson	= [[ABPerson alloc] initWithVCardRepresentation:separatedVCardData];
//		ahkPerson	= [[AHKPerson alloc] initWithABPerson:abPerson];
//		
//		if (ahkPerson) {
//			[array addObject:ahkPerson];
//		}
//		[abPerson release];
//		[ahkPerson release];
//	}
//	
//	[string release];
//	[scanner release];
//	
//	return array;
//}
//
//+ (NSData *)vCardRepresentationOfPeople:(NSArray *)people format:(AHKVCardFormat)format
//{
//	NSMutableString *combinedVCardString	= [NSMutableString stringWithCapacity:(256 * [people count])];
//	
//	NSEnumerator	*enumerator				= [people objectEnumerator];
//	AHKPerson		*person;
//	
//	while (person = [enumerator nextObject]) {
//		NSString *singleVCardString = [person vCardRepresentationStringWithFormat:format];
//		if (singleVCardString) {
//			[combinedVCardString appendString:singleVCardString];
//		}
//	}
//	
//	if (format == AHKAddressBookVCardFormat) {
//		return [combinedVCardString dataUsingEncoding:NSUnicodeStringEncoding
//								 allowLossyConversion:YES];
//	} else if (format == AHKKyoponVCardFormat) {
//		return [combinedVCardString dataUsingEncoding:NSShiftJISStringEncoding
//								 allowLossyConversion:YES];
//	} else {
//		return nil;
//	}
//}
//
//


//
//- (NSString *)vCardRepresentationStringWithFormat:(AHKVCardFormat)format
//{
//	if (format == AHKKyoponVCardFormat) {
//	
//	} else if (format == AHKAddressBookVCardFormat) {
//		NSMutableString *vCardString = [NSMutableString stringWithCapacity:1024];
//		
//		[vCardString appendString:@"BEGIN:VCARD\r\nVERSION:3.0\r\n"];
//		
//		if ([self name]) {
//			NSArray *components = [[self name] componentsSeparatedByString:@" "];
//			int count = [components count];
//			[vCardString appendFormat:@"N:%@;%@;%@;%@;%@\r\n",
//				(count > 0 ? [components objectAtIndex:0] : @""),
//				(count > 1 ? [components objectAtIndex:1] : @""),
//				(count > 2 ? [components objectAtIndex:2] : @""),
//				(count > 3 ? [components objectAtIndex:3] : @""),
//				(count > 4 ? [[components subarrayWithRange:NSMakeRange(4,count-4)] componentsJoinedByString:@" "] : @"")];
//			[vCardString appendFormat:@"FN:%@\r\n", [self name]];
//		}
//		
////		[vCardString appendFormat:@"X-REDUCTION:%i\r\n", [self number]];
////		
//		if ([self phoneticName]) {
//			NSString *fullwidthPhoneticName = [[self phoneticName] stringByReplacingHalfwidthKanaToFullwidthKana];
//			
//			NSArray *components = [fullwidthPhoneticName componentsSeparatedByString:@" "];
//			int count = [components count];
//			if (count == 1) {
//				[vCardString appendFormat:@"X-PHONETIC-LAST-NAME:%@\r\n", [components objectAtIndex:0]];
//			} else if (count == 2) {
//				[vCardString appendFormat:@"X-PHONETIC-FIRST-NAME:%@\r\nX-PHONETIC-LAST-NAME:%@\r\n",
//					[components objectAtIndex:0],
//					[components objectAtIndex:1]];
//			} else if (count >= 3) {
//				[vCardString appendFormat:@"X-PHONETIC-LAST-NAME:%@\r\nX-PHONETIC-FIRST-NAME:%@\r\nX-PHONETIC-MIDDLE-NAME:%@\r\n",
//					[components objectAtIndex:0], 
//					[components objectAtIndex:1], 
//					[[components subarrayWithRange:NSMakeRange(2, count - 2)] componentsJoinedByString:@" "]];
//			}
//		}
////		
////		[vCardString appendFormat:@"X-GNO:%i\r\n", [self groupNumber]];
//		
//		NSString *valueString;
//		int i;
//		int preferredIndex;
//		
//		preferredIndex = [[self phones] indexForPreferredValue];
//		for (i = 0; i < 3; i++) {
//			if (valueString = [[self phones] valueAtIndex:i]) {
//				NSString *labelString = [[self phones] labelStringAtIndex:i];
//				if (i == preferredIndex) {
//					[vCardString appendFormat:@"TEL;type=%@;type=PREF:%@\r\n", labelString, valueString];
//				} else {
//					[vCardString appendFormat:@"TEL;type=%@:%@\r\n", labelString, valueString];
//				}
//			}
//		}
//		
//		preferredIndex = [[self emails] indexForPreferredValue];
//		for (i = 0; i < 3; i++) {
//			if (valueString = [[self emails] valueAtIndex:i]) {
//				NSString *labelString = [[self emails] labelStringAtIndex:i];
//				if (i == preferredIndex) {
//					[vCardString appendFormat:@"EMAIL;type=%@;type=PREF:%@\r\n", labelString, valueString];
//				} else {
//					[vCardString appendFormat:@"EMAIL;type=%@:%@\r\n", labelString, valueString];
//				}
//			}
//		}
//		
//		if (valueString = [self addressValue]) {
//			NSArray *components = [valueString componentsSeparatedByString:@" "];
//			
//			
//			NSString	*zipCode	= @"";
//			if ([valueString length] != 0 && [[NSCharacterSet decimalDigitCharacterSet] characterIsMember:[valueString characterAtIndex:0]]) {
//				zipCode = [components objectAtIndex:0];
//				components = [components subarrayWithRange:NSMakeRange(1,[components count] - 1)];
//			}
////			NSString	*street		= @"";
////			NSString	*city		= @"";
////			NSString	*state		= @"";
////			NSString	*zipCode	= @"";
////			
////			switch ([components count]) {
////				case 4: zipCode	= [components objectAtIndex:[components count] - 4];
////				case 3: state	= [components objectAtIndex:[components count] - 3];
////				case 2:	city	= [components objectAtIndex:[components count] - 2];
////				case 1:	street	= [components objectAtIndex:[components count] - 1];
////			}
//			[vCardString appendFormat:@"ADR;type=%@;type=pref:;;%@;%@;%@;%@;%@\r\n",
//				[self addressLabelString],
//				([components count] > 2 ? [[components subarrayWithRange:NSMakeRange(2,[components count] - 2)] componentsJoinedByString:@" "] : [components componentsJoinedByString:@" "]), 
//				([components count] > 2 ? [components objectAtIndex:1] : @""), 
//				([components count] > 2 ? [components objectAtIndex:0] : @""), 
//				zipCode,
//				@""];
//		}
//		
////		if ([self bloodType] != AHKUnclassifiedBloodType) {
////			[vCardString appendFormat:@"X-BLOODTYPE:%@\r\n", [self bloodTypeString]];
////		}
//		
//		if ([self birthday]) {
//			int year = [[self birthday] yearOfCommonEra];
//			int month = [[self birthday] monthOfYear];
//			int day = [[self birthday] dayOfMonth];
//			
//			[vCardString appendFormat:@"BDAY;value=date:%04d-%02d-%02d\r\n", year, month, day];
//		}
//		
////		if ([self zodiac] != AHKUnclassifiedConstellation) {
////			[vCardString appendFormat:@"X-CONSTELLATION:%@\r\n", [self zodiacString]];
////		}
////		
////		if ([self hobby]) {
////			[vCardString appendFormat:@"X-HOBBY:%@\r\n", [self hobby]];
////		}
////		
//		if ([self note]) {
//			[vCardString appendFormat:@"NOTE:%@\r\n", [self note]];
//		}
//		
//		if ([self url]) {
//			[vCardString appendFormat:@"URL:%@\r\n", [self url]];
//		}
//		
////		if ([self isSecured]) {
////			[vCardString appendString:@"CLASS:PRIVATE\r\n"];
////		} else {
////			[vCardString appendString:@"CLASS:PUBLIC\r\n"];
////		}
//		
//		[vCardString appendString:@"END:VCARD\r\n"];
//		
//		return vCardString;
//	}
//	return nil;
//}
//
//
//+ (BOOL)scanTypeArray:(NSArray *)typeArray intoLabelString:(NSString **)labelString preferred:(BOOL *)isPreferred
//{
//	*labelString	= nil;
//	*isPreferred	= NO;
//	
//	BOOL		b = NO;
//	int			i, j;
//	NSString	*typeDefinition;
//	NSArray		*typeValues;
//	NSString	*typeValue;
//	
//	for (i = 1; i < [typeArray count]; i++) {
//		typeDefinition = [typeArray objectAtIndex:i];
//		if ([typeDefinition length] > 5 && [[[typeDefinition substringToIndex:5] uppercaseString] isEqualToString:@"TYPE="]) {
//			typeValues = [[typeDefinition substringFromIndex:5] componentsSeparatedByString:@","];
//			for (j = 0; j < [typeValues count]; j++) {
//				typeValue = [typeValues objectAtIndex:j];
//				if ([[typeValue uppercaseString] isEqualToString:@"PREF"]) {
//					*isPreferred = YES;
//				} else {
//					*labelString = typeValue;
//					b = YES;
//				}
//			}
//		}
//	}
//	return b;
//}
//
//@end
